CREATE PROC [dbo].[GetUpisani]
	@OsobaPredbiljezbe_ID int 
as
declare @Osoba_ID int
declare @Tecajevi_ID int
select 
	@Osoba_ID = op.Osoba_ID,
	@Tecajevi_ID = p.Tecajevi_ID
from tblOsobaPredbiljezbe p 
inner join tblOsobaPodaci op on p.OsobaPodaci_ID = op.OsobaPodaci_ID
where p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID

-- Bitno: ako je ova predbiljeba samo za poduslugu, onda cijene vratim za poduslugu, a ne za uslugu.
declare @SamoPodusluga bit
declare @PoduslugaID int
declare @PoduslugaNaziv nvarchar(100)
if exists(select * from dbo.vwPredbiljezbaSpec where OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID and Usluga_ID is null and Podusluga_ID is not null) begin
	set @SamoPodusluga = 1
	select @PoduslugaNaziv = t.Naziv, @PoduslugaID = t.Tecajevi_ID from dbo.tblOsobaPredbiljezbeSpec ps
	inner join dbo.tblPodusluga pu on ps.Podusluga_ID = pu.Podusluga_ID
	inner join dbo.tblTecajevi t on pu.Child_ID = t.Tecajevi_ID
	where ps.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
end
else
	set @SamoPodusluga = 0

declare @tip int
select
	@tip = case
		when [dbo].[GetIsUpisan](@OsobaPredbiljezbe_ID, 1) = 1 then 1 -- Pojedinac
		when [dbo].[GetIsUpisan](@OsobaPredbiljezbe_ID, 2) = 1 then 2 -- Operater
		when [dbo].[GetIsUpisan](@OsobaPredbiljezbe_ID, 3) = 1 then 3 -- Specijalac
		else 0
	end

select 
	case
		when @tip = 0 then CAST(0 as bit)
		else CAST(1 as bit)
	end as Upisan,
	@tip as TipUpisanogPolaznika--,
	--@kredita as BrojRaspolozivihKredita

--------------------------------------------------------------------
-- Ako se radi o operateru, onda ne dohvaam podatke za traeni @OsobaPredbiljezbe_ID,
-- nego za PRVI seminar u programu obrazovanja. Informacije o kliknutom seminaru
-- sauvam za potrebe pretvaranja operater -> pojedinac.
declare @OsobaPredbiljezbe_ID_kliknuti int
set @OsobaPredbiljezbe_ID_kliknuti = @OsobaPredbiljezbe_ID

declare @isOP bit
set @isOP = 0

declare @tmpGrupa nvarchar(50)
declare @OsobaPodaci_ID int
select @tmpGrupa = GlavnaGrupa, @OsobaPodaci_ID = OsobaPodaci_ID from tblOsobaPredbiljezbe where OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID

if @tip = 2 begin
	set @isOP = 1
end
else if @tip = 0 begin
	-- Iako je neupisan, moe biti operater.	
	if @tmpGrupa is not null begin
		set @isOP = 1
	end
end

if @isOP = 1 begin
	-- Uzmem prvu predbiljezbu za tog polaznika i tu grupu.
	select top 1
		@OsobaPredbiljezbe_ID = p.OsobaPredbiljezbe_ID
	from
		tblOsobaPredbiljezbe p
	inner join tblRasporedZaglavlje rz on p.RasporedZaglavlje_ID = rz.RasporedZaglavlje_ID
	where
		p.GlavnaGrupa = @tmpGrupa
		and p.OsobaPodaci_ID = @OsobaPodaci_ID
	order by
		--p.OsobaPredbiljezbe_ID asc
		rz.Datum asc
end
--------------------------------------------------------------------

-- [2/8] tblRasporedZaglavlje i tblRasporedDatumi.
select
	rz.*,
	case
		when @SamoPodusluga = 0 then t.Naziv 
		else @PoduslugaNaziv
	end as TecajNaziv,
	rd.*,
	case
		when @SamoPodusluga = 0 then t.Naziv 
		else @PoduslugaNaziv
	end as SeminarNaziv,
	u.Naziv as UcionicaNaziv,
	case
		when @SamoPodusluga = 0 then t.CijenaPoduzeca
		else (select CijenaPoduzeca from tblTecajevi where Tecajevi_ID = @PoduslugaID)
	end as gotovina,
	case
		when @SamoPodusluga = 0 then (t.CijenaCekovi * (1 + t.PoreznaStopa / 100))
		else (select (CijenaCekovi * (1 + PoreznaStopa / 100)) from tblTecajevi where Tecajevi_ID = @PoduslugaID)
	end as cekovi,
	case
		when @SamoPodusluga = 0 then t.CijenaPoduzeca
		else (select CijenaPoduzeca from tblTecajevi where Tecajevi_ID = @PoduslugaID)
	end as CijenaPoduzeca,
	case
		when @SamoPodusluga = 0 then t.PoreznaStopa
		else (select PoreznaStopa from tblTecajevi where Tecajevi_ID = @PoduslugaID)
	end as PoreznaStopa,
	dbo.GetSveGrupeZaSeminar(rz.RasporedZaglavlje_ID, ',') as Grupe
from
	tblOsobaPredbiljezbe p
inner join tblRasporedZaglavlje rz on p.RasporedZaglavlje_ID = rz.RasporedZaglavlje_ID
inner join tblRasporedDatumi rd on rz.RasporedZaglavlje_ID = rd.RasporedZaglavlje_ID and rz.Datum = rd.Datum
inner join tblTecajevi t on rz.Tecajevi_ID = t.Tecajevi_ID
inner join tblUcionica u on rd.Ucionica_ID = u.Ucionica_ID
where 
	p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	
-- [3/8] tblOsoba.
select 
	o.* 
from 
	tblOsoba o 
inner join tblOsobaPodaci op on o.Osoba_ID = op.Osoba_ID
inner join tblOsobaPredbiljezbe p on op.OsobaPodaci_ID = p.OsobaPodaci_ID
where 
	p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	
-- [4/8] tblOsobaPodaci.
select 
	op.* 
from 
	tblOsobaPodaci op
inner join tblOsobaPredbiljezbe p on op.OsobaPodaci_ID = p.OsobaPodaci_ID
where 
	p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	
-- [5/8] tblOsobaIsprave.
select 
	oi.* 
from 
	tblOsobaPodaci op
inner join tblOsobaPredbiljezbe p on op.OsobaPodaci_ID = p.OsobaPodaci_ID
inner join tblOsobaIsprave oi on op.OsobaPodaci_ID = oi.OsobaPodaci_ID
where 
	p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	
-- [6/8] tblOsobaPredbiljezba.
select 
	p.* 
from 
	tblOsobaPredbiljezbe p
where 
	p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID

-- [7/8] Ponude.
select
	pu.*,
	ppon.*
from
	Ponuda_Polaznik pp
inner join Ponuda_Usluga pu on pp.UslugaID = pu.UslugaID
inner join Ponuda_Ponuda ppon on pu.PonudaID = ppon.PonudaID
where
	pp.RedniBrojPredbiljezbe = @OsobaPredbiljezbe_ID

-- [8/8] Rauni.
select
	ru.*,
	rr.*
from
	Racun_Polaznik rp
inner join Racun_Usluga ru on rp.UslugaID = ru.UslugaID
inner join Racun_Racun rr on ru.RacunID = rr.RacunID
where
	rp.RedniBrojPredbiljezbe = @OsobaPredbiljezbe_ID
-- Kraj zajednikog dijela.

-- Specifini dio.
if @tip = 1 begin
	-- [1/2] tblUpisTecaj.
	select
		ut.*
	from
		tblUpisTecajPredbiljezbe utp
	inner join tblUpisTecaj ut on utp.UpisTecaj_ID = ut.UpisTecaj_ID
	where
		utp.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
		
	-- [2/2] tblUpisTecajRate.
	select
		utr.*
	from
		tblUpisTecajPredbiljezbe utp
	inner join tblUpisTecaj ut on utp.UpisTecaj_ID = ut.UpisTecaj_ID
	inner join tblUpisTecajRate utr on ut.UpisTecaj_ID = utr.UpisTecaj_ID
	where
		utp.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	order by
		utr.UpisTecajRate_ID
end
else if @tip = 2 or @isOP = 1 begin
	-- [1/4] Cijene programa.
	declare @s nvarchar(200)
	declare @i bigint
	set @s = REVERSE(@tmpGrupa)
	set @i = CHARINDEX('-', REVERSE(@tmpGrupa), 0)
	select
		Naziv, Ime, iznos, cekovi, poduzeca, uvjeti, 
		(
			select cast(cekoviIznos as money) from tblObrazovanjeCekovi
			where obrazovanje = Naziv and cekoviRedniBroj = 1
		) as Upisnina
	from 
		tblObrazovanje
	where
		Naziv = REVERSE(substring(@s, @i + 1, LEN(@s) - @i))
		
	-- [2/4] tblUpisPO.
	select
		upo.*
	from
		tblUpisPOPredbiljezbe upop
	inner join tblUpisPO upo on upo.UpisPO_ID = upop.UpisPO_ID
	where
		upop.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
		
	-- [3/4] tblUpisPORate.
	select
		upor.*
	from
		tblUpisPOPredbiljezbe upop
	inner join tblUpisPO upo on upop.UpisPO_ID = upo.UpisPO_ID
	inner join tblUpisPORate upor on upo.UpisPO_ID = upor.UpisPO_ID
	where
		upop.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	order by
		upor.UpisPORate_ID
	
	-- [4/4] Informacije o kliknutom seminaru.
	select
		t.Naziv as TecajNaziv,
		rz.RasporedZaglavlje_ID,
		rd.RasporedDatumi_ID,
		p.OsobaPredbiljezbe_ID,
		rd.Datum,
		u.Naziv as UcionicaNaziv,
		rd.TerminOd,
		rd.TerminDo,
		t.CijenaPoduzeca AS gotovina,
		(t.CijenaCekovi * (1 + t.PoreznaStopa / 100)) AS cekovi, 
		t.CijenaPoduzeca, 
		t.PoreznaStopa
	from
		tblOsobaPredbiljezbe p
	inner join tblRasporedZaglavlje rz on p.RasporedZaglavlje_ID = rz.RasporedZaglavlje_ID
	inner join tblRasporedDatumi rd on rz.RasporedZaglavlje_ID = rd.RasporedZaglavlje_ID and rz.Datum = rd.Datum
	inner join tblUcionica u on rd.Ucionica_ID = u.Ucionica_ID
	inner join tblTecajevi t on rz.Tecajevi_ID = t.Tecajevi_ID
	where 
		p.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID_kliknuti
end
else if @tip = 3 begin
	-- [1/4] tblUpisTecaj.
	select
		ut.*
	from
		tblUpisTecajPredbiljezbe utp
	inner join tblUpisTecaj ut on utp.UpisTecaj_ID = ut.UpisTecaj_ID
	where
		utp.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
		
	-- [2/4] tblUpisTecajRate.
	select
		utr.*
	from
		tblUpisTecajPredbiljezbe utp
	inner join tblUpisTecaj ut on utp.UpisTecaj_ID = ut.UpisTecaj_ID
	inner join tblUpisTecajRate utr on ut.UpisTecaj_ID = utr.UpisTecaj_ID
	where
		utp.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	order by
		utr.UpisTecajRate_ID
	
	-- [3/4] tblUpisPOUgovorPredbiljezba.
	select * from tblUpisPOUgovorPredbiljezbe where OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
	
	-- [4/4] tblUpisPOUgovor.
	select 
		u.*,
		o.Ime,
		o.uvjeti
	from
		tblUpisPOUgovorPredbiljezbe up
	inner join tblUpisPOUgovor u on up.UpisPOUgovor_ID = u.UpisPOUgovor_ID
	inner join tblObrazovanje o on u.UpisaniPO = o.Naziv
	where 
		up.OsobaPredbiljezbe_ID = @OsobaPredbiljezbe_ID
end
go
